function NavPostRule()
{
	this.direction = null;
	this.action = null;
	this.combine = null;
	this.operator = null;
	this.conditions = null;
	this.params = null; // used only for GOTO, GOSUB and
	                    // GOSUB_RETURN - holds node id(s).
					  
	this.setDefaultValues();
}
NavPostRule.prototype.loadFromXMLNode = NavPostRuleLoadFromXMLNode;
NavPostRule.prototype.setDefaultValues = NavPostRuleSetDefaultValues;
NavPostRule.prototype.toString = NavPostRuleToString;
NavPostRule.prototype.resolveReferences = NavPostRuleResolveReferences;
NavPostRule.prototype.evaluate = NavPostRuleEvaluate;
NavPostRule.prototype.clone = NavPostRuleClone;

function NavPostRuleClone()
{
	var retVal = new NavPostRule();
	
	retVal.direction = this.direction;
	retVal.action = this.action;
	retVal.combine = this.combine;
	retVal.operator = this.operator;
	
	retVal.conditions = new Array();
	for (var i=0;i<this.conditions.length;i++)
	{
		retVal.conditions[i] = this.conditions[i].clone();
	}
	
	retVal.params = new Array();
	for (var i=0;i<this.params.length;i++)
	{
		retVal.params[i] = this.params[i];
	}
	
	return retVal;
}

function NavPostRuleEvaluate()
{
	var str = "";
	var strOp = ((this.combine==NAV_COMBINE_AND)?("&&"):("||"));
	
	str = ((this.operator==NAV_OPERATOR_NOT)?("(!"):(""));
	for (var i=0;i<this.conditions.length;i++)
	{
		str += this.conditions[i].evaluate() + ((i<this.conditions.length-1)?(" " + strOp + " "):(""));
	}
	str += ((this.operator==NAV_OPERATOR_NOT)?(")"):(""));
	return (eval(str) == true);
}

function NavPostRuleResolveReferences(navRef)
{	
	for (var i=0;i<this.conditions.length;i++)
	{
		this.conditions[i].resolveReferences(navRef);
	}
}

function NavPostRuleToString()
{
	var str = "";
	var strOp = ((this.combine==NAV_COMBINE_AND)?("and"):("or"));
	var strAction;
	
	switch (this.action)
	{
		case NAV_POST_ACTION_RESET:strAction="reset";break;
		case NAV_POST_ACTION_RETRY:strAction="retry";break;
		case NAV_POST_ACTION_NEXT:strAction="continue";break;
		case NAV_POST_ACTION_PREVIOUS:strAction="previous";break;
		case NAV_POST_ACTION_GOTO:strAction="goto " + this.params[0];break;
		case NAV_POST_ACTION_GOSUB:strAction="gosub " + this.params[0];break;
		case NAV_POST_ACTION_GOSUB_RETURN:strAction="gosub " + this.params[0] + " and return to " + this.params[1];break;
		case NAV_POST_ACTION_RESET+NAV_POST_ACTION_RETRY:strAction="reset and retry";break;
		case NAV_POST_ACTION_RESET+NAV_POST_ACTION_NEXT:strAction="reset and continue";break;
		case NAV_POST_ACTION_RESET+NAV_POST_ACTION_PREVIOUS:strAction="reset and previous";break;
		case NAV_POST_ACTION_RESET+NAV_POST_ACTION_GOTO:strAction="reset and goto " + this.params[0];break;
		case NAV_POST_ACTION_RESET+NAV_POST_ACTION_GOSUB:strAction="reset and gosub " + this.params[0];break;
		case NAV_POST_ACTION_RESET+NAV_POST_ACTION_GOSUB_RETURN:strAction="reset and gosub " + this.params[0] + " and return to " + this.params[1];break;
	}
	str = strAction + " if " + ((this.operator==NAV_OPERATOR_NOT)?("(not "):(""));
	for (var i=0;i<this.conditions.length;i++)
	{
		str += this.conditions[i].toString() + ((i<this.conditions.length-1)?(" " + strOp + " "):(""));
	}
	str += ((this.operator==NAV_OPERATOR_NOT)?(")"):(""));
	str += ((this.direction & NAV_DIRECTION_REVERSE > 0)?("<-"):("")) + ((this.direction & NAV_DIRECTION_FORWARD > 0)?("->"):(""))
	return str;
}

function NavPostRuleSetDefaultValues()
{
	this.direction = NAV_DIRECTION_FORWARD;
	this.action = NAV_POST_ACTION_NEXT;
	this.combine = NAV_COMBINE_AND;
	this.operator = NAV_OPERATOR_NO_OP;
	this.conditions = new Array();
	this.params = new Array(); // used only for GOTO, GOSUB and
}

function NavPostRuleLoadFromXMLNode(xmlNode)
{
	var temp;
	this.setDefaultValues();

	var action = xmlNode.getAttribute("action");
	switch (action.toLowerCase())
	{
		case "reset":this.action = NAV_POST_ACTION_RESET;this.params = "";break;
		case "retry":this.action = NAV_POST_ACTION_RETRY;this.params = "";break;
		case "resetandretry":this.action = NAV_POST_ACTION_RESET + NAV_POST_ACTION_RETRY;this.params = "";break;
		case "next":this.action = NAV_POST_ACTION_NEXT;this.params = "";break;
		case "nextandreset":this.action = NAV_POST_ACTION_RESET + NAV_POST_ACTION_NEXT;this.params = "";break;
		case "previous":this.action = NAV_POST_ACTION_PREVIOUS;this.params = "";break;
		case "previousandreset":this.action = NAV_POST_ACTION_RESET + NAV_POST_ACTION_PREVIOUS;this.params = "";break;
		case "goto":
			this.action = NAV_POST_ACTION_GOTO;
			this.params = trimWhitespace(xmlNode.getAttribute("params")).split(",");
			break;
		case "gotoandreset":
			this.action = NAV_POST_ACTION_RESET + NAV_POST_ACTION_GOTO;
			this.params = trimWhitespace(xmlNode.getAttribute("params")).split(",");
			break;
		case "gosub":
			this.action = NAV_POST_ACTION_GOSUB;
			this.params = trimWhitespace(xmlNode.getAttribute("params")).split(",");
			break;
		case "gosubandreset":
			this.action = NAV_POST_ACTION_RESET + NAV_POST_ACTION_GOSUB;
			this.params = trimWhitespace(xmlNode.getAttribute("params")).split(",");
			break;
		case "gosubreturn":
			this.action = NAV_POST_ACTION_GOSUB_RETURN;
			this.params = trimWhitespace(xmlNode.getAttribute("params")).split(",");
			break;
		case "gosubreturnandreset":
			this.action = NAV_POST_ACTION_RESET + NAV_POST_ACTION_GOSUB_RETURN;
			this.params = trimWhitespace(xmlNode.getAttribute("params")).split(",");
			break;
	}

	var operator = xmlNode.getAttribute("operator");
	switch ((operator+"").toLowerCase())
	{
		case "not":this.operator = NAV_OPERATOR_NOT;break;
		case "noop":this.operator = NAV_OPERATOR_NO_OP;break;
		default:this.operator = NAV_OPERATOR_NO_OP;break;
	}
	
	var combine = xmlNode.getAttribute("combine");
	switch ((combine+"").toLowerCase())
	{
		case "and":this.combine = NAV_COMBINE_AND;break;
		case "or":this.combine = NAV_COMBINE_OR;break;
		default:this.combine = NAV_COMBINE_AND;break;
	}

	for (var i=0;i<xmlNode.children.length;i++)
	{
		if (xmlNode.children[i].nodeType == "ELEMENT")
		{
			var isAggregator;
			var objTemp;
			var nodeName = xmlNode.children[i].tagName.toLowerCase();
			
			if (nodeName == "condand" || nodeName == "condor")
			{
				objTemp = new NavRuleConditionAggregator();
			}
			else
			{
				objTemp = new NavRuleCondition();
			}
			objTemp.loadFromXMLNode(xmlNode.children[i]);
			this.conditions[this.conditions.length] = objTemp;
		}
	}
	
	temp = xmlNode.getAttribute("forward");
	if (temp != null)
	{
		if ((temp+"").toLowerCase() == "false")
		{
			this.direction = NAV_DIRECTION_REVERSE;
		}
	}

	if (this.direction != NAV_DIRECTION_REVERSE)
	{
		temp = xmlNode.getAttribute("reverse");
		if (temp != null)
		{
			if ((temp+"").toLowerCase() == "true")
			{
				this.direction = NAV_DIRECTION_REVERSE + NAV_DIRECTION_FORWARD;
			}
		}
	}
}

//****************************************************************************
//
// trimWhitespace()
// Helper function that trims whitespace from the begining and end of a String.
//
// Input Params: strVal - String - the String to be trimmed.
//
// Output Params: None
//
// Returns: String - the trimmed version of strVal.
//
// Calls/References: None
//
//****************************************************************************
function trimWhitespace(strVal)
{
	if (strVal == null) strVal = "";
	var strTemp = "";
	var charCode = 0;
	// Search, from the begining of strVal to the end, until a non-whitespace
	// character is encountered; save everything from that position to the end
	// in the variable strTemp and break out of the loop.
	for (var i=0;i<strVal.length;i++)
	{
		charCode = strVal.charCodeAt(i);
		if (charCode > 32)
		{
			strTemp = strVal.slice(i,strVal.length);
			break;
		}
	}
	
	// Search, from the end of strTemp to the begining, until a non-whitespace character
	// is encountered; save everything from that position to the begining in strTemp and
	// break out of the loop.
	for (var i=strTemp.length-1;i>-1;i--)
	{
		charCode = strVal.charCodeAt(i);
		if (charCode > 32)
		{
			strTemp = strTemp.slice(0,i+1);
			break;
		}
	}
	return strTemp;
}
